<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel\Repository;

use InPost\International\PrestaShop\ObjectModel\ObjectManagerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @template T of \ObjectModel
 *
 * @extends ObjectRepository<T>
 */
abstract class AbstractServiceObjectRepository extends ObjectRepository
{
    public function __construct(ObjectManagerInterface $manager)
    {
        parent::__construct(static::getDefaultModelName(), $manager);
    }

    /**
     * Used to generate an index for a tagged service locator injected into {@see ObjectRepositoryFactory}.
     *
     * @return class-string<T>
     */
    abstract public static function getDefaultModelName(): string;
}
