<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel\Repository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends AbstractServiceObjectRepository<\Country>
 */
class CountryRepository extends AbstractServiceObjectRepository
{
    /**
     * @var array<string, \Country|null>
     */
    private $countriesByIsoCode = [];

    public static function getDefaultModelName(): string
    {
        return \Country::class;
    }

    public function findOneByIsoCode(string $isoCode): ?\Country
    {
        if (array_key_exists($isoCode, $this->countriesByIsoCode)) {
            return $this->countriesByIsoCode[$isoCode];
        }

        return $this->countriesByIsoCode[$isoCode] = $this->findOneBy(['iso_code' => $isoCode], ['active' => 'DESC']);
    }
}
