<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel\Repository;

use InPost\International\PrestaShop\ObjectModel\ObjectManagerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ObjectRepositoryFactoryInterface
{
    /**
     * @template T of \ObjectModel
     *
     * @param class-string<T> $class
     *
     * @return ObjectRepositoryInterface<T>
     */
    public function getRepository(ObjectManagerInterface $manager, string $class): ObjectRepositoryInterface;
}
