<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel\Repository;

use InPost\International\PrestaShop\ObjectModel\QueryBuilder;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @template T of \ObjectModel
 */
interface ObjectRepositoryInterface
{
    /**
     * @return class-string<T>
     */
    public function getClassName(): string;

    /**
     * @return T|null
     */
    public function find(int $id, int $languageId = null, int $shopId = null): ?\ObjectModel;

    /**
     * @return T[]
     */
    public function findAll(int $languageId = null, int $shopId = null): array;

    /**
     * @return T|null
     */
    public function findOneBy(array $criteria, array $orderBy = null): ?\ObjectModel;

    /**
     * @return T[]
     */
    public function findBy(array $criteria, array $orderBy = null, int $limit = null, int $offset = null): array;

    /**
     * @return QueryBuilder<T>
     */
    public function createQueryBuilder(string $alias, int $languageId = null, int $shopId = null): QueryBuilder;
}
