<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel\Repository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends AbstractServiceObjectRepository<\Order>
 */
class OrderRepository extends AbstractServiceObjectRepository
{
    public static function getDefaultModelName(): string
    {
        return \Order::class;
    }

    /**
     * @return \Order[]
     */
    public function findByIdsAndCarrierModuleName(string $moduleName, int ...$orderIds): array
    {
        if ([] === $orderIds) {
            return [];
        }

        return $this
            ->createQueryBuilder('o')
            ->innerJoin('carrier', 'c', 'c.id_carrier = o.id_carrier')
            ->andWhere(sprintf('c.external_module_name = "%s"', pSQL($moduleName)))
            ->andWhere(sprintf('o.id_order IN (%s)', implode(',', $orderIds)))
            ->build()
            ->getResult();
    }
}
