<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\ObjectModel\Repository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends AbstractServiceObjectRepository<\TaxRulesGroup>
 */
class TaxRulesGroupRepository extends AbstractServiceObjectRepository
{
    public static function getDefaultModelName(): string
    {
        return \TaxRulesGroup::class;
    }

    public function findOneByTaxRateAndCountryId(float $taxRate, int $countryId): ?\TaxRulesGroup
    {
        if (0 >= $countryId) {
            return null;
        }

        return $this
            ->createQueryBuilder('trg')
            ->innerJoin('tax_rule', 'tr', 'tr.id_tax_rules_group = trg.id_tax_rules_group')
            ->innerJoin('tax', 't', 't.id_tax = tr.id_tax')
            ->andWhere('tr.id_country = ' . $countryId)
            ->andWhere('t.rate = ' . $taxRate)
            ->andWhere('trg.deleted = 0')
            ->andWhere('tr.id_state = 0')
            ->limit(1)
            ->build()
            ->getOneOrNullResult();
    }
}
