<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\Shop;

use PrestaShop\PrestaShop\Core\Domain\Shop\ValueObject\ShopConstraint;
use PrestaShop\PrestaShop\Core\Shop\ShopConstraintContextInterface as BaseInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

if (interface_exists(BaseInterface::class)) {
    interface ShopConstraintContextInterface extends BaseInterface
    {
    }
} else {
    interface ShopConstraintContextInterface
    {
        public function getShopConstraint(): ShopConstraint;
    }
}
