<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop\Shop;

use PrestaShop\PrestaShop\Adapter\Shop\Context;
use PrestaShop\PrestaShop\Core\Domain\Shop\ValueObject\ShopConstraint;
use PrestaShop\PrestaShop\Core\Shop\ShopConstraintContextInterface as BaseContextInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @mixin Context
 */
final class ShopContext implements ShopConstraintContextInterface
{
    /**
     * @var Context
     */
    private $context;

    public function __construct(Context $context = null)
    {
        $this->context = $context ?? new Context();
    }

    public function getShopConstraint(bool $strict = false): ShopConstraint
    {
        if ($this->context instanceof BaseContextInterface) {
            return $this->context->getShopConstraint($strict);
        }

        if ($this->context->isShopContext()) {
            return ShopConstraint::shop((int) $this->context->getContextShopID(), $strict);
        }

        if ($this->context->isGroupShopContext()) {
            return ShopConstraint::shopGroup((int) $this->context->getContextShopGroup()->id, $strict);
        }

        return ShopConstraint::allShops();
    }

    /**
     * Forwards calls to the inner context.
     *
     * @return mixed
     */
    public function __call(string $name, array $arguments)
    {
        return $this->context->$name(...$arguments);
    }
}
