<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PrestaShop;

use PrestaShop\PrestaShop\Core\ConfigurationInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ShopConfigurationRepository
{
    private const DEFAULT_COUNTRY_ID_KEY = 'PS_COUNTRY_DEFAULT';

    /**
     * @var ConfigurationInterface
     */
    private $configuration;

    public function __construct(ConfigurationInterface $configuration)
    {
        $this->configuration = $configuration;
    }

    public function getDefaultCountryId(): int
    {
        return (int) $this->configuration->get(self::DEFAULT_COUNTRY_ID_KEY);
    }
}
