<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\PropertyInfo;

use InPost\International\PropertyInfo\Extractor\PropertyDocBlockTypeExtractor;
use phpDocumentor\Reflection\DocBlockFactory;
use Symfony\Component\PropertyInfo\Extractor\PhpDocExtractor;
use Symfony\Component\PropertyInfo\Extractor\ReflectionExtractor;
use Symfony\Component\PropertyInfo\PropertyInfoExtractor;
use Symfony\Component\PropertyInfo\PropertyTypeExtractorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PropertyTypeExtractorFactory
{
    private function __construct()
    {
    }

    public static function create(): PropertyTypeExtractorInterface
    {
        $typeExtractors = [];

        if (class_exists(DocBlockFactory::class)) {
            $typeExtractors[] = new PhpDocExtractor();
        } else {
            $typeExtractors[] = new PropertyDocBlockTypeExtractor();
        }

        $typeExtractors[] = new ReflectionExtractor();

        return new PropertyInfoExtractor([], $typeExtractors);
    }
}
