<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Serializer;

use Symfony\Component\Serializer\Exception\ExceptionInterface;
use Symfony\Component\Serializer\SerializerInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

trait SafeDeserializerTrait
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @template T
     *
     * @param class-string<T> $class
     *
     * @return T|null
     */
    private function deserialize(string $value, string $class, string $format = 'json', array $context = [])
    {
        try {
            return $this->serializer->deserialize($value, $class, $format, $context);
        } catch (ExceptionInterface $e) {
            return null;
        }
    }
}
