<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Serializer;

use InPost\International\Api\Point\Serializer\TimeRangeArrayDenormalizer;
use InPost\International\Enum\Serializer\EnumDenormalizer;
use InPost\International\PropertyInfo\PropertyTypeExtractorFactory;
use Symfony\Component\Serializer\Encoder\JsonEncoder;
use Symfony\Component\Serializer\Normalizer\ArrayDenormalizer;
use Symfony\Component\Serializer\Normalizer\DateTimeNormalizer;
use Symfony\Component\Serializer\Normalizer\JsonSerializableNormalizer;
use Symfony\Component\Serializer\Normalizer\ObjectNormalizer;
use Symfony\Component\Serializer\Serializer;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SerializerFactory
{
    private function __construct()
    {
    }

    public static function create(iterable $normalizers, iterable $encoders): Serializer
    {
        $normalizers = is_array($normalizers) ? $normalizers : iterator_to_array($normalizers);
        $encoders = is_array($encoders) ? $encoders : iterator_to_array($encoders);

        return new Serializer($normalizers, $encoders);
    }

    public static function createDefault(ObjectNormalizer $objectNormalizer = null): Serializer
    {
        $objectNormalizer = $objectNormalizer ?? new ObjectNormalizer(
            null,
            null,
            null,
            PropertyTypeExtractorFactory::create()
        );

        return self::create([
            new EnumDenormalizer(),
            new DateTimeNormalizer(),
            new JsonSerializableNormalizer(),
            new TimeRangeArrayDenormalizer(),
            new ArrayDenormalizer(),
            $objectNormalizer,
        ], [new JsonEncoder()]);
    }
}
