<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\DTO;

use InPost\International\Api\Shipment\Model\Parcel\DimensionUnit;
use InPost\International\Shipment\Validator\ParcelDimensions;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @Assert\GroupSequence({"Dimensions", "parcel"})
 * @ParcelDimensions(groups={"parcel"})
 */
final class Dimensions
{
    /**
     * @var float|null
     *
     * @Assert\NotBlank
     * @Assert\GreaterThan(0)
     */
    private $length;

    /**
     * @var float|null
     *
     * @Assert\NotBlank
     * @Assert\GreaterThan(0)
     */
    private $width;

    /**
     * @var float|null
     *
     * @Assert\NotBlank
     * @Assert\GreaterThan(0)
     */
    private $height;

    /**
     * @var DimensionUnit|null
     *
     * @Assert\NotNull
     */
    private $unit;

    public function __construct()
    {
        $this->unit = DimensionUnit::getDefault();
    }

    public function getLength(): ?float
    {
        return $this->length;
    }

    public function setLength(?float $length): Dimensions
    {
        $this->length = $length;

        return $this;
    }

    public function getUnit(): ?DimensionUnit
    {
        return $this->unit;
    }

    public function setUnit(?DimensionUnit $unit): Dimensions
    {
        $this->unit = $unit;

        return $this;
    }

    public function getHeight(): ?float
    {
        return $this->height;
    }

    public function setHeight(?float $height): Dimensions
    {
        $this->height = $height;

        return $this;
    }

    public function getWidth(): ?float
    {
        return $this->width;
    }

    public function setWidth(?float $width): Dimensions
    {
        $this->width = $width;

        return $this;
    }
}
