<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\DTO;

use InPost\International\Api\Shipment\Model\Parcel\ParcelType;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Parcel
{
    /**
     * @var ParcelType|null
     *
     * @Assert\NotNull
     */
    private $type;

    /**
     * @var Dimensions|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $dimensions;

    /**
     * @var Weight|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $weight;

    /**
     * @var string|null
     *
     * @Assert\Length(max=128)
     */
    private $comment;

    /**
     * @var string|null
     */
    private $barcode;

    public function __construct()
    {
        $this->type = ParcelType::Standard();
    }

    public function getType(): ?ParcelType
    {
        return $this->type;
    }

    public function setType(?ParcelType $type): Parcel
    {
        $this->type = $type;

        return $this;
    }

    public function getDimensions(): ?Dimensions
    {
        return $this->dimensions;
    }

    public function setDimensions(Dimensions $dimensions): Parcel
    {
        $this->dimensions = $dimensions;

        return $this;
    }

    public function getWeight(): ?Weight
    {
        return $this->weight;
    }

    public function setWeight(Weight $weight): Parcel
    {
        $this->weight = $weight;

        return $this;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function setComment(?string $comment): Parcel
    {
        $this->comment = $comment;

        return $this;
    }

    public function getBarcode(): ?string
    {
        return $this->barcode;
    }

    public function setBarcode(?string $barcode): Parcel
    {
        $this->barcode = $barcode;

        return $this;
    }
}
