<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\DTO;

use InPost\International\Api\Shipment\Model\Parcel\WeightUnit;
use InPost\International\Shipment\Validator\ParcelWeight;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @Assert\GroupSequence({"Weight", "parcel"})
 * @ParcelWeight(groups={"parcel"})
 */
final class Weight
{
    /**
     * @var float|null
     *
     * @Assert\NotBlank
     * @Assert\GreaterThan(0)
     */
    private $amount;

    /**
     * @var WeightUnit|null
     *
     * @Assert\NotNull
     */
    private $unit;

    public function __construct()
    {
        $this->unit = WeightUnit::getDefault();
    }

    public function getAmount(): ?float
    {
        return $this->amount;
    }

    public function setAmount(?float $amount): Weight
    {
        $this->amount = $amount;

        return $this;
    }

    public function getUnit(): ?WeightUnit
    {
        return $this->unit;
    }

    public function setUnit(?WeightUnit $unit): Weight
    {
        $this->unit = $unit;

        return $this;
    }
}
