<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Doctrine;

use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Query\Filter\SQLFilter;
use InPost\International\Entity\Shipment;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SandboxQueryFilter extends SQLFilter
{
    public function addFilterConstraint(ClassMetadata $targetEntity, $targetTableAlias): string
    {
        if (Shipment::class !== $targetEntity->getName()) {
            return '';
        }

        return sprintf('%s.is_sandbox = %s', $targetTableAlias, $this->getParameter('sandbox'));
    }
}
