<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Doctrine;

use InPost\International\Configuration\Repository\ApiConfigurationRepositoryInterface;
use InPost\International\Shipment\ShipmentRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @internal
 */
final class ShipmentRepositoryConfigurator
{
    /**
     * @var ApiConfigurationRepositoryInterface
     */
    private $apiConfiguration;

    public function __construct(ApiConfigurationRepositoryInterface $apiConfiguration)
    {
        $this->apiConfiguration = $apiConfiguration;
    }

    public function configure(ShipmentRepository $repository): void
    {
        $sandbox = $this->apiConfiguration->getConfiguration()->getEnvironment()->isTestEnvironment();
        $repository->enableSandboxFilter($sandbox);
    }
}
