<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Event;

use InPost\International\Entity\Shipment;
use InPost\International\EventDispatcher\Event;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ShipmentStatusUpdatedEvent extends Event
{
    /**
     * @var Shipment
     */
    private $shipment;

    /**
     * @var string
     */
    private $previousStatus;

    public function __construct(Shipment $shipment, string $previousStatus)
    {
        $this->shipment = $shipment;
        $this->previousStatus = $previousStatus;
    }

    public function getShipment(): Shipment
    {
        return $this->shipment;
    }

    public function getPreviousStatus(): string
    {
        return $this->previousStatus;
    }
}
