<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Exception;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ShipmentNotFoundException extends ShipmentException
{
    /**
     * @var int
     */
    private $shipmentId;

    public function __construct(int $shipmentId, string $message = '')
    {
        parent::__construct($message);
        $this->shipmentId = $shipmentId;
    }

    public static function create(int $shipmentId): self
    {
        return new self($shipmentId, sprintf('Shipment with ID %d does not exist.', $shipmentId));
    }

    public function getShipmentId(): int
    {
        return $this->shipmentId;
    }
}
