<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Form\Type;

use InPost\International\Api\Shipment\Model\Parcel\DimensionUnit;
use InPost\International\Enum\Form\Type\EnumType;
use InPost\International\Shipment\DTO\Dimensions;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DimensionsType extends AbstractType
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('length', NumberType::class, [
                'label' => $this->translator->trans('Length', [], 'Modules.Inpostinternational.Shipment'),
                'html5' => true,
                'attr' => [
                    'step' => 'any',
                ],
            ])
            ->add('width', NumberType::class, [
                'label' => $this->translator->trans('Width', [], 'Admin.Global'),
                'html5' => true,
                'attr' => [
                    'step' => 'any',
                ],
            ])
            ->add('height', NumberType::class, [
                'label' => $this->translator->trans('Height', [], 'Admin.Global'),
                'html5' => true,
                'attr' => [
                    'step' => 'any',
                ],
            ])
            ->add('unit', EnumType::class, [
                'class' => DimensionUnit::class,
                'choice_label' => static function (DimensionUnit $unit): string {
                    return $unit->getSymbol();
                },
                'label' => $this->translator->trans('Unit', [], 'Modules.Inpostinternational.Shipment'),
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Dimensions::class,
            'error_bubbling' => false,
        ]);
    }
}
