<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Form\Type;

use InPost\International\Api\Shipment\Model\Parcel\WeightUnit;
use InPost\International\Enum\Form\Type\EnumType;
use InPost\International\Shipment\DTO\Weight;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class WeightType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('amount', NumberType::class, [
                'label' => false,
                'html5' => true,
                'attr' => [
                    'step' => 'any',
                ],
            ])
            ->add('unit', EnumType::class, [
                'class' => WeightUnit::class,
                'choice_label' => static function (WeightUnit $unit): string {
                    return $unit->getSymbol();
                },
                'label' => false,
            ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Weight::class,
        ]);
    }
}
