<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Message;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class BulkUpdateShipmentStatusesCommand
{
    /**
     * @var int[]
     */
    private $shipmentIds;

    public function __construct(int ...$shipmentIds)
    {
        $this->shipmentIds = $shipmentIds;
    }

    /**
     * @return int[]
     */
    public function getShipmentIds(): array
    {
        return $this->shipmentIds;
    }
}
