<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\Message;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class GetTrackingDetailsCommand
{
    /**
     * @var int
     */
    private $shipmentId;

    public function __construct(int $shipmentId)
    {
        $this->shipmentId = $shipmentId;
    }

    public function getShipmentId(): int
    {
        return $this->shipmentId;
    }
}
