<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\MessageHandler\Result;

use InPost\International\Entity\Shipment;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreateShipmentsResult
{
    /**
     * @var array<int, Shipment>
     */
    private $shipments;

    /**
     * @var array<int, \Exception>
     */
    private $errors;

    /**
     * @param array<int, Shipment> $shipments shipments by order ID
     * @param array<int, \Exception> $errors errors by order ID
     */
    public function __construct(array $shipments, array $errors)
    {
        $this->shipments = $shipments;
        $this->errors = $errors;
    }

    /**
     * @return array<int, Shipment> shipments by order ID
     */
    public function getShipments(): array
    {
        return $this->shipments;
    }

    /**
     * @return array<int, \Exception> errors by order ID
     */
    public function getErrors(): array
    {
        return $this->errors;
    }
}
