<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class TrackingUrlGenerator
{
    private const URL_PATTERN_EN = 'https://inpost.pl/en/find-parcel?number=%s';
    private const URL_PATTERN_PL = 'https://inpost.pl/sledzenie-przesylek?number=%s';

    private function __construct()
    {
    }

    public static function generate(string $trackingNumber, string $language = 'en'): string
    {
        $pattern = 'pl' === $language ? self::URL_PATTERN_PL : self::URL_PATTERN_EN;

        return sprintf($pattern, $trackingNumber);
    }
}
