<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\View\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class TrackingDetailsView
{
    /**
     * @var string
     */
    private $trackingNumber;

    /**
     * @var string
     */
    private $destination;

    /**
     * @var TrackingEventView[]
     */
    private $events;

    /**
     * @param TrackingEventView[] $events
     */
    public function __construct(string $trackingNumber, string $destination, array $events)
    {
        $this->trackingNumber = $trackingNumber;
        $this->destination = $destination;
        $this->events = $events;
    }

    public function getTrackingNumber(): string
    {
        return $this->trackingNumber;
    }

    public function getDestination(): string
    {
        return $this->destination;
    }

    /**
     * @return TrackingEventView[]
     */
    public function getEvents(): array
    {
        return $this->events;
    }
}
