<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Shipment\View\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class TrackingEventView
{
    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $date;

    public function __construct(string $title, string $date)
    {
        $this->title = $title;
        $this->date = $date;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getDate(): string
    {
        return $this->date;
    }
}
