<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Storage;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface StorageInterface
{
    /**
     * @return mixed
     */
    public function get(string $key);

    /**
     * @return mixed the removed value or null if it did not exist
     */
    public function remove(string $key);

    /**
     * @param mixed $value
     */
    public function set(string $key, $value): void;
}
