<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Templating;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SmartyRenderer implements RendererInterface
{
    /**
     * @var \Smarty
     */
    private $smarty;

    /**
     * @var string|null
     */
    private $compileId;

    public function __construct(\Smarty $smarty, string $compileId = null)
    {
        $this->smarty = $smarty;
        $this->compileId = $compileId;
    }

    /**
     * {@inheritDoc}
     */
    public function render(string $name, array $parameters = []): string
    {
        if ([] !== $parameters) {
            $scope = $this->smarty->createData($this->smarty);
            $scope->assign($parameters);
        } else {
            $scope = $this->smarty;
        }

        return $this->smarty->createTemplate($name, null, $this->compileId, $scope)->fetch();
    }
}
