<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Translation\Message;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ImportTranslationsCommand
{
    /**
     * @var string
     */
    private $directory;

    /**
     * @param string $directory path to a directory containing XLF files grouped by locale
     */
    public function __construct(string $directory)
    {
        $this->directory = $directory;
    }

    public function getDirectory(): string
    {
        return $this->directory;
    }
}
