/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */
!function(){"use strict";class e{constructor(e,t,i=null){if(!e)throw new Error("AjaxContentRefresher requires a valid input element.");if(!t||"string"!=typeof t&&!Array.isArray(t))throw new Error("AjaxContentRefresher requires a target selector.");if(this.input=e,this.targetSelectors=Array.isArray(t)?t:[t],this.formDataBuilder=i??this.#e,this.form=this.input.closest("form"),!this.form)throw new Error("The select element must be inside a form.")}init(){this.input.addEventListener("change",this.#t.bind(this))}onContentRefreshed(e){return this.callback=e,this}#t(e){const t=new FormData;this.formDataBuilder(t),fetch(this.form.action,{method:this.form.method,body:new URLSearchParams(t).toString(),headers:{"X-Requested-With":"XMLHttpRequest","Content-Type":"application/x-www-form-urlencoded",charset:"utf-8"}}).then(e=>{if(!e.ok&&422!==e.status)throw new Error(`HTTP error! status: ${e.status}`);return e.text()}).then(e=>(new DOMParser).parseFromString(e,"text/html")).then(e=>{this.targetSelectors.forEach(t=>{const i=e.querySelector(t),r=document.querySelector(t);if(!i||!r)throw new Error(`Could not find target element or new content for selector: ${t}`);i.querySelectorAll(".invalid-feedback-container").forEach(e=>e.remove()),r.innerHTML=i.innerHTML}),"function"==typeof this.callback&&this.callback()}).catch(e=>{console.error("Error during content refresh:",e)})}#e(e){e.append(this.input.name,this.input.value)}}class t{#i={};on(e,t){return this.#i[e]||(this.#i[e]=[]),this.#i[e].push(t),()=>{this.#i[e]=this.#i[e].filter(e=>e!==t)}}emit(e,t){this.#i[e]&&this.#i[e].forEach(e=>e(t))}}const i=new t;class r{element=null;api=null;widgetId="";constructor(e,i={}){if(this.target="string"==typeof e?document.querySelector(e):e,this.options=i,this.widgetId=`inpost-geowidget-${Math.random().toString(36).substring(2,15)}`,this.eventBus=i.eventBus||new t,!this.target)throw new Error("Target element not found")}static create(e,t={}){const i=new r(e,t);return i.init(),i}init(){return this.#r(),this}#r(){if(this.element=document.createElement("inpost-geowidget"),this.element.setAttribute("id",this.widgetId),!this.options.token)throw new Error("Token is required for GeoWidget");if(!this.options.language)throw new Error("Language is required for GeoWidget");if(!this.options.country)throw new Error("Country is required for GeoWidget");this.element.setAttribute("token",this.options.token),this.element.setAttribute("language",this.options.language),this.element.setAttribute("config",this.options.config||"parcelCollect"),this.element.setAttribute("country",this.options.country),this.target.appendChild(this.element),this.element.addEventListener("inpost.geowidget.init",this.#s)}#s=e=>{this.api=e.detail.api,this.api.addPointSelectedCallback(e=>{this.eventBus.emit("pointSelected",{point:e,widget:this}),this.eventBus!==i&&i.emit("geowidget.pointSelected",{point:e,widget:this})}),this.options.pointValue&&this.api&&this.showPoint(this.options.pointValue),this.eventBus.emit("init",{widget:this,api:this.api}),this.eventBus!==i&&i.emit("geowidget.init",{widget:this,api:this.api})};on(e,t){return this.eventBus.on(e,t)}showPoint(e){return this.api&&e&&(this.api.showPoint(e),this.api.showPointDetails(e)),this}destroy(){this.element&&this.element.parentNode&&this.element.parentNode.removeChild(this.element),this.api=null,this.element=null,this.eventBus.emit("destroy",{widget:this})}}var s=r;new class{#n=new Map;#o=0;register(e,t=null){const i=t||e.wrapper||this.#l();return this.#n.set(i,e),i}unregister(e){return this.#n.delete(e)}get(e){return this.#n.get(e)}getAll(){return Array.from(this.#n.values())}destroyAll(){this.#n.forEach(e=>{e.destroy()}),this.#n.clear()}destroyByKeys(e){e.forEach(e=>{const t=this.#n.get(e);t&&(t.destroy(),this.#n.delete(e))})}#l(){return"selector-"+ ++this.#o}count(){return this.#n.size}};class n{itemsWrapperSelector;itemSelector;removeButtonSelector;addButtonSelector;constructor({itemsWrapperSelector:e,itemSelector:t,removeButtonSelector:i,addButtonSelector:r}){if("string"!=typeof e)throw new Error('CollectionFormSelectors requires a "itemsWrapperSelector" string.');if(this.itemsWrapperSelector=e,"string"!=typeof t)throw new Error('CollectionFormSelectors requires a "itemSelector" string.');if(this.itemSelector=t,"string"!=typeof i)throw new Error('CollectionFormSelectors requires a "removeButtonSelector" string.');if(this.removeButtonSelector=i,"string"!=typeof r)throw new Error('CollectionFormSelectors requires a "addButtonSelector" string.');this.addButtonSelector=r}}class o{static EVENT_ITEM_ADD="item:add";static EVENT_ITEM_ADDED="item:added";static EVENT_ITEM_REMOVE="item:remove";static EVENT_ITEM_REMOVED="item:removed";constructor(e,i){if(!(i instanceof n))throw new Error("CollectionForm requires an instance of CollectionFormSelectors.");this.wrapper=e,this.selectors=i,this.eventBus=new t,this.itemsWrapper=this.wrapper.querySelector(this.selectors.itemsWrapperSelector),this.prototype=this.wrapper.dataset.prototype,this.itemCount=0}init(){this.wrapper&&this.itemsWrapper&&this.prototype?(this.itemCount=this.itemsWrapper.querySelectorAll(this.selectors.itemSelector).length,this.#a()):console.error("CollectionForm cannot be initialized. Missing required elements or data-prototype.")}#a(){this.wrapper.querySelectorAll(this.selectors.removeButtonSelector).forEach(e=>{this.#h(e)});const e=this.wrapper.querySelector(this.selectors.addButtonSelector);e&&e.addEventListener("click",e=>{e.preventDefault(),this.#c()})}#h(e){e.addEventListener("click",t=>{this.eventBus.emit(o.EVENT_ITEM_REMOVE),t.preventDefault();const i=e.closest(this.selectors.itemSelector);i&&(i.remove(),this.eventBus.emit(o.EVENT_ITEM_REMOVED,{item:i}))})}#c(){this.eventBus.emit(o.EVENT_ITEM_ADD);const e=document.createElement("template");e.innerHTML=this.prototype.replace(/__name__/g,this.itemCount++);const t=e.content.firstElementChild;this.itemsWrapper.append(t);const i=t.querySelector(this.selectors.removeButtonSelector);i&&this.#h(i),this.eventBus.emit(o.EVENT_ITEM_ADDED,{item:t})}}class l{length;width;height;dimensionUnit;weight;weightUnit;constructor(e,t,i,r,s,n){if("string"!=typeof e)throw new Error('ParcelTemplateFieldsSelectors requires a "length" string selector.');if(this.length=e,"string"!=typeof t)throw new Error('ParcelTemplateFieldsSelectors requires a "width" string selector.');if(this.width=t,"string"!=typeof i)throw new Error('ParcelTemplateFieldsSelectors requires a "height" string selector.');if(this.height=i,"string"!=typeof r)throw new Error('ParcelTemplateFieldsSelectors requires a "dimensionUnit" string selector.');if(this.dimensionUnit=r,"string"!=typeof s)throw new Error('ParcelTemplateFieldsSelectors requires a "weight" string selector.');if(this.weight=s,"string"!=typeof n)throw new Error('ParcelTemplateFieldsSelectors requires a "weightUnit" string selector.');this.weightUnit=n}}class a{constructor(e,t){if(!e)throw new Error("ParcelTemplateObserver requires a template select element.");if(!(t instanceof l))throw new Error("ParcelTemplateObserver requires an instance of ParcelTemplateFieldsSelectors.");this.templateSelect=e,this.selectors=t}init(){this.templateSelect.addEventListener("change",this.#d.bind(this))}#d(e){const t=e.target,i=t.options[t.selectedIndex];if(i&&i.dataset.dimensions&&i.dataset.weight)try{const e=JSON.parse(i.dataset.dimensions),t=JSON.parse(i.dataset.weight);this.#p(this.selectors.length,e.length),this.#p(this.selectors.width,e.width),this.#p(this.selectors.height,e.height),this.#u(this.selectors.dimensionUnit,e.unit),this.#p(this.selectors.weight,t.weight),this.#u(this.selectors.weightUnit,t.unit)}catch(e){console.error("Error updating parcel fields from template:",e)}}#p(e,t){const i=document.querySelector(e);i&&(i.value=t)}#u(e,t){const i=document.querySelector(e);i&&(i.value=t)}}class h{constructor(e,t,i){if(this.modalElement=document.getElementById(e),this.triggerSelector=t,this.geoWidgetContainer=document.getElementById(i),!this.modalElement||!this.geoWidgetContainer)throw new Error("GeoWidgetModal: Modal or GeoWidget container not found.");this.$modal=$(this.modalElement),this.widget=null,this.activeTargetInput=null}init(){"undefined"!=typeof inPostIntlGeoWidgetConfig?(document.addEventListener("click",e=>{const t=e.target.closest(this.triggerSelector);t&&this.#m(t)}),i.on("geowidget.pointSelected",this.#g.bind(this))):console.warn("GeoWidgetModal: global inPostIntlGeoWidgetConfig is not defined.")}#m(e){this.activeTargetInput=document.querySelector(e.dataset.target),this.activeTargetInput?(this.widget||this.#w(),this.$modal.modal("show")):console.error("GeoWidgetModal: Target input not found for the trigger button.")}#w(){this.widget=s.create(this.geoWidgetContainer,{...inPostIntlGeoWidgetConfig,country:this.activeTargetInput.dataset.country,pointValue:this.activeTargetInput.value})}#g({point:e}){this.activeTargetInput&&e&&(this.activeTargetInput.value=e.name,this.$modal.modal("hide"),this.activeTargetInput.dispatchEvent(new Event("change",{bubbles:!0})))}}$(()=>{const t=document.querySelector(".js-inpost-intl-service-choice");function i(e){e.append(t.name,t.value),document.querySelector(".js-inpost-intl-optional-services-wrapper")?.querySelectorAll("input, select").forEach(t=>{e.append(t.name,t.value)})}function r(){const t=document.querySelector(".js-inpost-intl-destination-country-choice");new e(t,".js-inpost-intl-optional-services-wrapper",e=>{i(e),e.append(t.name,t.value)}).init()}t&&(new e(t,[".js-inpost-intl-destination-wrapper",".js-inpost-intl-optional-services-wrapper"],i).onContentRefreshed(r).init(),r());const s=document.querySelector(".js-inpost-intl-shipping-method-choice");s&&new e(s,".js-inpost-intl-shipping-options-wrapper").init();const c=document.getElementById("inpost_intl_shipment_references");if(c){const e=new n({itemsWrapperSelector:".js-inpost-intl-collection-items",itemSelector:".js-inpost-intl-collection-item",removeButtonSelector:".js-inpost-intl-remove-collection-item",addButtonSelector:".js-inpost-intl-add-collection-item"});new o(c,e).init()}const d=document.getElementById("inpost_intl_shipment_parcel_template");if(d){const e=new l("#inpost_intl_shipment_parcel_dimensions_length","#inpost_intl_shipment_parcel_dimensions_width","#inpost_intl_shipment_parcel_dimensions_height","#inpost_intl_shipment_parcel_dimensions_unit","#inpost_intl_shipment_parcel_weight_amount","#inpost_intl_shipment_parcel_weight_unit");new a(d,e).init()}new h("inpost_intl_geowidget_modal",".js-inpost-intl-geowidget-button","inpost_intl_geowidget").init()})}();