{**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 *}
{function inpost_intl_hidden_widget}
  <input
    type="hidden"
    name="{$form->vars.full_name}"
    id="{$form->vars.id}"
    value="{$form->vars.value}"
    {foreach $form->vars.attr as $name => $value}
      {$name}="{$value}"
    {/foreach}
  >
{/function}

{function inpost_intl_point_delivery_options_widget}
  {inpost_intl_hidden_widget form=$form.pointId}

  <div class="js-inpost-intl-point-select-wrapper" data-target="#{$form.pointId->vars.id}">
    {$selected_point = $view.selected_point}
    {$closest_point = $view.closest_point}

    <div class="js-inpost-intl-point-details"{if null === $selected_point} style="display: none"{/if}>
      <p>
        {l s='Selected pickup point' d='Modules.Inpostinternational.Checkout'}:
        <span class="js-inpost-intl-point-name">
          {$selected_point.name|default:''}
        </span>
      </p>

      <address class="js-inpost-intl-point-address">
        {$selected_point.formatted_address|default:''}
      </address>
    </div>

    <div class="form-group">
      <a
        href="#"
        role="button"
        class="btn btn-primary js-inpost-intl-map-button"
        data-selected-text="{l s='Change the selected pickup point'
        d='Modules.Inpostinternational.Checkout'}">
        {if null === $selected_point}
          {l s='Select pickup point' d='Modules.Inpostinternational.Checkout'}
        {else}
          {l s='Change the selected pickup point' d='Modules.Inpostinternational.Checkout'}
        {/if}
      </a>
    </div>

    {if null !== $closest_point}
      <div>
        <p class="font-weight-bold mt-2">
          {l s='Nearest pickup point: {distance} away from you ({pointId})' sprintf=[
            '{distance}' => $closest_point.distance,
            '{pointId}' => $closest_point.name
          ] d='Modules.Inpostinternational.Checkout'}
        </p>

        <a
          href="#"
          role="button"
          class="btn btn-secondary js-inpost-intl-select-point"
          data-address="{$closest_point.formatted_address}"
          data-name="{$closest_point.name}"
        >
          {l s='Select this point' d='Modules.Inpostinternational.Checkout'}
        </a>
      </div>
    {/if}

    <div class="modal fade js-inpost-intl-map-modal" tabindex="-1" role="dialog" style="display: none;" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-lg" style="max-width: 90%; width: 90%; height: 90%; margin: 5vh auto">
        <div class="modal-content js-inpost-intl-map-content" style="display: block; width: 100%; height: 100%;"></div>
      </div>
    </div>
  </div>
{/function}

<div class="js-inpost-intl-delivery-options-form" data-carrier-id="{$view.carrier_id|intval}">
  {foreach $view.form as $child}
    {inpost_intl_point_delivery_options_widget form=$child}
  {/foreach}
</div>
