{**
 * Copyright since 2021 InPost S.A.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * You may obtain a copy of the Licence at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is also bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an AS IS basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the Licence for the specific language governing permissions
 * and limitations under the Licence.
 *
 * @author    InPost S.A.
 * @copyright Since 2021 InPost S.A.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 *}
<tr>
  <td>{$shipment.service|default:'__service__'|escape:'html':'UTF-8'}</td>
  <td>
    {if isset($shipment.parcels)}
      {foreach $shipment.parcels as $parcel}
        {$parcel.tracking_number|escape:'html':'UTF-8'}<br/>
      {/foreach}
    {else}
      __tracking_numbers__
    {/if}
  </td>
  <td>
    <a data-toggle="tooltip" title="{$shipment.status.description|default:'__status_description__'|escape:'html':'UTF-8'}">
      {$shipment.status.title|default:'__status_title__'|escape:'html':'UTF-8'}
    </a>
  </td>
  <td class="text-right">{$shipment.price|default:'__price__'|escape:'html':'UTF-8'}</td>
  <td>{$shipment.date_add|default:'__date_add__'|escape:'html':'UTF-8'}</td>
  <td class="text-right">
    <div class="btn-group-action">
      <div class="btn-group pull-right">
        <a href="{$shipment.viewUrl|default:'__view_url__'|escape:'html':'UTF-8'}"
           class="btn btn-default js-view-inpost-shipment-details"
           data-id-shipment="{if isset($shipment.id)}{$shipment.id|intval}{else}__id__{/if}"
        >
          <i class="icon-eye"></i>
          {l s='Details' mod='inpostshipping'}
        </a>

        <button class="btn btn-default dropdown-toggle" data-toggle="dropdown">
          <i class="icon-caret-down"></i>&nbsp;
        </button>

        <ul class="dropdown-menu js-inpost-shipping-shipment-actions" role="menu">
          {foreach $shipment.actions as $action_name => $action}
            {include './shipment-table-action.tpl'}
          {/foreach}
        </ul>
      </div>
    </div>
  </td>
</tr>
