<?php
/**
 * Copyright since 2021 InPost S.A.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * You may obtain a copy of the Licence at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is also bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an AS IS basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the Licence for the specific language governing permissions
 * and limitations under the Licence.
 *
 * @author    InPost S.A.
 * @copyright Since 2021 InPost S.A.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

namespace InPost\Shipping\Api\Query;

class CommaAggregator implements QueryAggregator
{
    public function aggregate(array $query): array
    {
        return $this->walkQuery($query);
    }

    private function walkQuery(array $query, string $keyPrefix = ''): array
    {
        $result = [];

        foreach ($query as $key => $value) {
            if ($keyPrefix) {
                $key = $this->prefix($key, $keyPrefix);
            }
            if (is_array($value)) {
                $result += $this->walkQuery($value, $key);
            } elseif (isset($result[$key])) {
                $result[$key][0] .= ',' . $value;
            } else {
                $result[$key] = [$value];
            }
        }

        return $result;
    }

    private function prefix($key, string $prefix): string
    {
        return is_int($key) ? $prefix : "{$prefix}[{$key}]";
    }
}
