<?php
/**
 * Copyright since 2021 InPost S.A.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * You may obtain a copy of the Licence at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is also bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an AS IS basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the Licence for the specific language governing permissions
 * and limitations under the Licence.
 *
 * @author    InPost S.A.
 * @copyright Since 2021 InPost S.A.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

namespace InPost\Shipping\ChoiceProvider;

use InPost\Shipping\Presenter\DispatchPointPresenter;
use InPostDispatchPointModel;
use PrestaShopCollection;

class DispatchPointChoiceProvider implements ChoiceProviderInterface
{
    protected $presenter;

    protected $dispatchPoints;

    public function __construct(DispatchPointPresenter $dispatchPointPresenter)
    {
        $this->presenter = $dispatchPointPresenter;
    }

    public function getChoices()
    {
        $choices = [];

        $this->initCollection();

        /** @var InPostDispatchPointModel $dispatchPoint */
        foreach ($this->dispatchPoints as $dispatchPoint) {
            $choices[] = [
                'value' => (int) $dispatchPoint->id,
                'text' => $this->presenter->present($dispatchPoint),
            ];
        }

        return $choices;
    }

    protected function initCollection()
    {
        if (!isset($this->dispatchPoints)) {
            $this->dispatchPoints = (new PrestaShopCollection(InPostDispatchPointModel::class))
                ->where('deleted', '=', 0);
        }

        return $this;
    }
}
