<?php
/**
 * Copyright since 2021 InPost S.A.
 *
 * NOTICE OF LICENSE
 *
 * Licensed under the EUPL-1.2 or later.
 * You may not use this work except in compliance with the Licence.
 *
 * You may obtain a copy of the Licence at:
 * https://joinup.ec.europa.eu/software/page/eupl
 * It is also bundled with this package in the file LICENSE.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the Licence is distributed on an AS IS basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the Licence for the specific language governing permissions
 * and limitations under the Licence.
 *
 * @author    InPost S.A.
 * @copyright Since 2021 InPost S.A.
 * @license   https://joinup.ec.europa.eu/software/page/eupl
 */

namespace InPost\Shipping\ShipX\Exception;

use Exception;

class ShipXException extends Exception
{
    protected $details;

    /**
     * @var int|null
     */
    private $status;

    public function __construct($responseContents, Exception $previous = null)
    {
        if (isset($responseContents['message'])) {
            $message = $responseContents['message'];
        } elseif (null !== $previous) {
            $message = $previous->getMessage();
        } else {
            $message = '';
        }

        parent::__construct($message, 0, $previous);

        if (isset($responseContents['details'])) {
            $this->details = $responseContents['details'];
        }

        if (isset($responseContents['status'])) {
            $this->status = $responseContents['status'];
        }
    }

    public function getDetails()
    {
        return $this->details;
    }

    /**
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
}
